/*****************************************************************************
 *
 * Copyright 2019 NXP
 * All Rights Reserved
 *
 *****************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
*****************************************************************************/

#include <stdio.h>
#include <opencv2/opencv.hpp>
#include <umat.hpp>
#include <iostream>
#include <fstream>
#include <iomanip>

#include "../../A53_gen/inc/apu_add_process_controller.hpp"
#include "apu_add_process_controller_policy.hpp"

#include "apu_process_controller_data.hpp"

using namespace cv;
using namespace std;
using namespace apugen;

#ifdef APEX2_EMULATE
#include "apu_app_config.hpp"
#include "apu_lib.hpp"
#include "apu_extras.hpp"
#include "acf_lib.hpp"
using namespace APEX2;
#else
#include <icp_data.h>
#include <apex.h>
#include <oal.h>
using namespace icp;
#endif
//Start of user code user_define
/*
 * This is the region protected from the source code emitter,
 * all the rest can be changed by the source code emitter without notice.
 */

#if !defined(APEX2_EMULATE)
#include "frame_output_v234fb.h"
#define CHNL_CNT io::IO_DATA_CH3
#endif
//End of user code

int TEST_CALL()
{
#ifdef APEX2_EMULATE
  setvbuf(stdout, NULL, _IONBF, 0);
  setvbuf(stderr, NULL, _IONBF, 0);
  APU_App_Config::LoadConfig("./A53_inc/apu_app.cfg");
#endif

  uint8_t* lPtrInPointerInlet0 = new uint8_t[256*256];
  uint8_t* lPtrInPointerInlet1 = new uint8_t[256*256];
  uint8_t* lPtrInPointerInlet2 = new uint8_t[256*256];
  uint8_t* lPtrInPointerInlet3 = new uint8_t[256*256];
  //Start of user code declare_inputs
  /*
   * This is the region protected from the source code emitter,
   * all the rest can be changed by the source code emitter without notice.
   */
  for (int i = 0; i < 256 * 256; ++i)
  {
	uint8_t val0 = rand() % 256;
	uint8_t val1 = rand() % 256;

	lPtrInPointerInlet0[i] = lPtrInPointerInlet2[i] = val0;
	lPtrInPointerInlet1[i] = lPtrInPointerInlet3[i] = val1;
  }
  //End of user code

  uint16_t* lPtrOutPointerOutlet0 = new uint16_t[256*256];
  
  uint16_t* lPtrOutPointerOutlet1 = new uint16_t[256*256];
  
  //Start of user code declare_outputs
  /*
   * This is the region protected from the source code emitter,
   * all the rest can be changed by the source code emitter without notice.
   */

  //End of user code

  //========================================================================
  // Processing part
  //========================================================================
  int32_t retVal = 0;
  
  APU_Add_Process_Controller Add0ProcessController(0);
  
  APU_Add_Process_Controller Add1ProcessController(1);
  //-------------------------------- apuAdd0ProcessController --------------------------------
  InputProcessControllerData<uint8_t*, AddInput0ConversionPolicy> lAdd0Input0(256, 256, VSDK_CV_8UC1);
  InputProcessControllerData<uint8_t*, AddInput1ConversionPolicy> lAdd0Input1(256, 256, VSDK_CV_8UC1);
  //Start of user code input_data_Add0
/*
 * This is the region protected from the source code emitter,
 * all the rest can be changed by the source code emitter without notice.
 */

  //End of user code
  lAdd0Input0.SetData(lPtrInPointerInlet0);
  lAdd0Input1.SetData(lPtrInPointerInlet1);
  
  OutputProcessControllerData<uint16_t*, AddOutput0ConversionPolicy> lAdd0Output0(256, 256, VSDK_CV_16UC1);
  //Start of user code output_data_Add0
/*
 * This is the region protected from the source code emitter,
 * all the rest can be changed by the source code emitter without notice.
 */

  //End of user code
  retVal |= Add0ProcessController.Init();
  retVal |= Add0ProcessController.Connect(lAdd0Input0.mGraphDescr, lAdd0Input1.mGraphDescr, lAdd0Output0.mGraphDescr);
  retVal |= Add0ProcessController.Start();
  retVal |= Add0ProcessController.Wait();
  
  //Start of user code Add0_after_run
  /*
   * This is the region protected from the source code emitter,
   * all the rest can be changed by the source code emitter without notice.
   */
  
    //End of user code
  
  if(retVal)
  {
    cout << "Add0ProcessController error\n";
    return retVal;
  }
  lAdd0Output0.GetData(lPtrOutPointerOutlet0);
  
  //-------------------------------- apuAdd1ProcessController --------------------------------
  InputProcessControllerData<uint8_t*, AddInput0ConversionPolicy> lAdd1Input0(256, 256, VSDK_CV_8UC1);
  InputProcessControllerData<uint8_t*, AddInput1ConversionPolicy> lAdd1Input1(256, 256, VSDK_CV_8UC1);
  //Start of user code input_data_Add1
/*
 * This is the region protected from the source code emitter,
 * all the rest can be changed by the source code emitter without notice.
 */

  //End of user code
  lAdd1Input0.SetData(lPtrInPointerInlet2);
  lAdd1Input1.SetData(lPtrInPointerInlet3);
  
  OutputProcessControllerData<uint16_t*, AddOutput0ConversionPolicy> lAdd1Output0(256, 256, VSDK_CV_16UC1);
  //Start of user code output_data_Add1
/*
 * This is the region protected from the source code emitter,
 * all the rest can be changed by the source code emitter without notice.
 */

  //End of user code
  retVal |= Add1ProcessController.Init();
  retVal |= Add1ProcessController.Connect(lAdd1Input0.mGraphDescr, lAdd1Input1.mGraphDescr, lAdd1Output0.mGraphDescr);
  retVal |= Add1ProcessController.Start();
  retVal |= Add1ProcessController.Wait();
  
  //Start of user code Add1_after_run
  /*
   * This is the region protected from the source code emitter,
   * all the rest can be changed by the source code emitter without notice.
   */
  
    //End of user code
  
  if(retVal)
  {
    cout << "Add1ProcessController error\n";
    return retVal;
  }
  lAdd1Output0.GetData(lPtrOutPointerOutlet1);
  //Start of user code processing_part
  /*
   * This is the region protected from the source code emitter,
   * all the rest can be changed by the source code emitter without notice.
   */

  //End of user code

  //========================================================================
  // Display part
  //========================================================================
  
  
  //Start of user code display_part
  /*
   * This is the region protected from the source code emitter,
   * all the rest can be changed by the source code emitter without notice.
   */
  vsdk::UMat lUserOutput(256, 256, VSDK_CV_16UC1);
  vsdk::Mat lMatUserOutput = lUserOutput.getMat(OAL_USAGE_NONCACHED);
  vsdk::Mat lMatInput0 = lAdd1Input0.mGraphDescr.getMat(OAL_USAGE_NONCACHED);
  vsdk::Mat lMatInput1 = lAdd1Input1.mGraphDescr.getMat(OAL_USAGE_NONCACHED);
  uint16_t * lpOut0 = lPtrOutPointerOutlet0;
  uint16_t * lpOut1 = lPtrOutPointerOutlet1;

  for (int i = 0; i < lMatUserOutput.rows; i++)
  {
    for (int j = 0; j < lMatUserOutput.cols; j++)
    {
      lMatUserOutput.at<uint16_t>(i, j) = lMatInput0.at<uint8_t>(i, j) + lMatInput1.at<uint8_t>(i, j);
    }
  }

  cout << "Comparison: \n";

  for (int i = 0; i < lMatUserOutput.rows; i++)
  {
    for (int j = 0; j < lMatUserOutput.cols; j++)
    {
      if (lMatUserOutput.at<uint16_t>(i, j) != *lpOut0++ ||
          lMatUserOutput.at<uint16_t>(i, j) != *lpOut1++)
      {
    	cout << "Data do not match.\n\n";
      	return 1;
      }
    }
  }

  cout << "All 3 outputs match! \n\n";

  //End of user code
  
  delete [] lPtrInPointerInlet0;
  delete [] lPtrInPointerInlet1;
  delete [] lPtrOutPointerOutlet0;
  delete [] lPtrInPointerInlet2;
  delete [] lPtrInPointerInlet3;
  delete [] lPtrOutPointerOutlet1;

  return 0;
}
